/*
 * Decompiled with CFR 0.152.
 */
package com.xiangcao.xiangcaomengjia.config;

import com.xiangcao.xiangcaomengjia.config.SellingBinConfig;
import com.xiangcao.xiangcaomengjia.config.XiangcaoTierConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PriceVariationData
extends SavedData {
    private static final String DATA_NAME = "xiangcaomengjia_price_variation";
    private static final int STACK_SIZE = 64;
    private final Map<String, Double> itemMultipliers = new HashMap<String, Double>();
    private final Map<String, Long> itemSoldCount = new HashMap<String, Long>();
    private final Map<String, Long> lastSellTick = new HashMap<String, Long>();
    private final Set<String> firstSoldThisPeriod = new HashSet<String>();
    private long lastRefreshTick;
    private final Random random = new Random();

    public static PriceVariationData get(ServerLevel level) {
        DimensionDataStorage storage = level.m_8895_();
        return (PriceVariationData)storage.m_164861_(PriceVariationData::load, PriceVariationData::new, DATA_NAME);
    }

    public static PriceVariationData load(CompoundTag tag) {
        CompoundTag entry;
        int i;
        ListTag list;
        PriceVariationData data = new PriceVariationData();
        data.lastRefreshTick = tag.m_128454_("lastRefreshTick");
        if (tag.m_128425_("items", 9)) {
            list = tag.m_128437_("items", 10);
            for (i = 0; i < list.size(); ++i) {
                entry = list.m_128728_(i);
                String id = entry.m_128461_("id");
                double mult = entry.m_128459_("m");
                if (!(mult > 0.0)) continue;
                data.itemMultipliers.put(id, mult);
            }
        }
        if (tag.m_128425_("sold", 9)) {
            list = tag.m_128437_("sold", 10);
            for (i = 0; i < list.size(); ++i) {
                entry = list.m_128728_(i);
                data.itemSoldCount.put(entry.m_128461_("id"), entry.m_128454_("c"));
            }
        }
        if (tag.m_128425_("lastSell", 9)) {
            list = tag.m_128437_("lastSell", 10);
            for (i = 0; i < list.size(); ++i) {
                entry = list.m_128728_(i);
                data.lastSellTick.put(entry.m_128461_("id"), entry.m_128454_("t"));
            }
        }
        if (tag.m_128425_("firstSold", 9)) {
            list = tag.m_128437_("firstSold", 8);
            for (i = 0; i < list.size(); ++i) {
                data.firstSoldThisPeriod.add(list.m_128778_(i));
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128356_("lastRefreshTick", this.lastRefreshTick);
        ListTag list = new ListTag();
        for (Map.Entry<String, Double> entry : this.itemMultipliers.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("id", entry.getKey());
            compoundTag.m_128347_("m", entry.getValue().doubleValue());
            list.add((Object)compoundTag);
        }
        tag.m_128365_("items", (Tag)list);
        ListTag soldList = new ListTag();
        for (Map.Entry<String, Long> entry : this.itemSoldCount.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("id", entry.getKey());
            compoundTag.m_128356_("c", entry.getValue().longValue());
            soldList.add((Object)compoundTag);
        }
        tag.m_128365_("sold", (Tag)soldList);
        ListTag listTag = new ListTag();
        for (Map.Entry<String, Long> entry : this.lastSellTick.entrySet()) {
            CompoundTag entry2 = new CompoundTag();
            entry2.m_128359_("id", entry.getKey());
            entry2.m_128356_("t", entry.getValue().longValue());
            listTag.add((Object)entry2);
        }
        tag.m_128365_("lastSell", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (String id : this.firstSoldThisPeriod) {
            listTag2.add((Object)StringTag.m_129297_((String)id));
        }
        tag.m_128365_("firstSold", (Tag)listTag2);
        return tag;
    }

    public Map<String, Double> getItemMultipliers() {
        return new HashMap<String, Double>(this.itemMultipliers);
    }

    public Map<String, Double> getEffectiveMultipliersForDisplay(ServerLevel level) {
        long tick = level.m_46467_();
        double capMax = XiangcaoTierConfig.priceCapMax();
        double capMin = XiangcaoTierConfig.priceCapMin();
        double fee = XiangcaoTierConfig.marketFeePercent() / 100.0;
        HashMap<String, Double> out = new HashMap<String, Double>();
        for (Map.Entry<String, Double> e : this.itemMultipliers.entrySet()) {
            String id = e.getKey();
            double base = e.getValue();
            double supply = this.getSupplyPenalty(id);
            double demand = this.getDemandBonus(id, tick);
            double mult = Math.max(0.01, base * (1.0 - supply) * (1.0 + demand));
            if (capMax > 0.0 && mult > capMax) {
                mult = capMax;
            }
            if (capMin > 0.0 && mult < capMin) {
                mult = capMin;
            }
            if (fee > 0.0) {
                mult *= Math.max(0.0, 1.0 - fee);
            }
            out.put(id, mult);
        }
        return out;
    }

    public long getLastRefreshTick() {
        return this.lastRefreshTick;
    }

    public void refresh(ServerLevel level) {
        if (!XiangcaoTierConfig.priceVariationEnabled()) {
            return;
        }
        long now = level.m_46467_();
        double min = XiangcaoTierConfig.priceMultiplierMin();
        double max = XiangcaoTierConfig.priceMultiplierMax();
        if (XiangcaoTierConfig.supplyDecayOnRefresh()) {
            double f = XiangcaoTierConfig.supplyDecayFactor();
            for (String id : new HashMap<String, Long>(this.itemSoldCount).keySet()) {
                long c = this.itemSoldCount.getOrDefault(id, 0L);
                long nc = (long)((double)c * f);
                if (nc <= 0L) {
                    this.itemSoldCount.remove(id);
                    continue;
                }
                this.itemSoldCount.put(id, nc);
            }
        }
        this.firstSoldThisPeriod.clear();
        Set<String> ids = SellingBinConfig.getInstance().getAllSellableItemIds();
        this.itemMultipliers.clear();
        for (String itemId : ids) {
            this.itemMultipliers.put(itemId, min + (max - min) * this.random.nextDouble());
        }
        if (XiangcaoTierConfig.priceSpikeEnabled() && !ids.isEmpty() && this.random.nextDouble() < XiangcaoTierConfig.priceSpikeChance()) {
            String[] arr = ids.toArray(new String[0]);
            String spikeId = arr[this.random.nextInt(arr.length)];
            double m = this.itemMultipliers.get(spikeId) * XiangcaoTierConfig.priceSpikeMultiplier();
            this.itemMultipliers.put(spikeId, m);
        }
        this.lastRefreshTick = now;
        this.m_77762_();
    }

    public void addSoldCount(String itemId, long amount, long currentTick) {
        if (XiangcaoTierConfig.supplyDropEnabled()) {
            this.itemSoldCount.merge(itemId, amount, Long::sum);
        }
        if (XiangcaoTierConfig.demandBonusEnabled()) {
            this.lastSellTick.put(itemId, currentTick);
        }
        this.firstSoldThisPeriod.add(itemId);
        this.m_77762_();
    }

    private double getSupplyPenalty(String itemId) {
        if (!XiangcaoTierConfig.supplyDropEnabled()) {
            return 0.0;
        }
        long sold = this.itemSoldCount.getOrDefault(itemId, 0L);
        int stacksPerStep = XiangcaoTierConfig.supplyDropStacksPerStep();
        double percentPerStep = XiangcaoTierConfig.supplyDropPercentPerStep();
        double maxPercent = XiangcaoTierConfig.supplyDropMaxPercent();
        long itemsPerStep = (long)stacksPerStep * 64L;
        if (itemsPerStep <= 0L) {
            return 0.0;
        }
        long steps = sold / itemsPerStep;
        double penalty = (double)steps * (percentPerStep / 100.0);
        return Math.min(maxPercent / 100.0, penalty);
    }

    private double getDemandBonus(String itemId, long currentTick) {
        if (!XiangcaoTierConfig.demandBonusEnabled()) {
            return 0.0;
        }
        long last = this.lastSellTick.getOrDefault(itemId, 0L);
        long elapsed = currentTick - last;
        int ticksPerStep = XiangcaoTierConfig.demandBonusTicksPerStep();
        if (ticksPerStep <= 0) {
            return 0.0;
        }
        long steps = elapsed / (long)ticksPerStep;
        double pct = XiangcaoTierConfig.demandBonusPercentPerStep() / 100.0;
        double maxPct = XiangcaoTierConfig.demandBonusMaxPercent() / 100.0;
        return Math.min(maxPct, (double)steps * pct);
    }

    public long getEffectivePriceForSell(long basePrice, String itemId, int amountConsumed, ServerLevel level) {
        double fee;
        double capMin;
        double capMax;
        int effectiveTypes;
        int stacks;
        double mult = 1.0;
        if (XiangcaoTierConfig.priceVariationEnabled()) {
            mult = this.itemMultipliers.getOrDefault(itemId, 1.0);
            double rp = XiangcaoTierConfig.priceRandomPercent();
            if (rp > 0.0) {
                mult *= 1.0 + (this.random.nextDouble() * 2.0 - 1.0) * rp / 100.0;
            }
        }
        double supply = this.getSupplyPenalty(itemId);
        mult *= Math.max(0.01, 1.0 - supply);
        long tick = level.m_46467_();
        mult *= 1.0 + this.getDemandBonus(itemId, tick);
        if (XiangcaoTierConfig.bulkBonusEnabled() && amountConsumed >= 64 && (stacks = amountConsumed / 64) >= XiangcaoTierConfig.bulkBonusStacks()) {
            mult *= 1.0 + XiangcaoTierConfig.bulkBonusPercent() / 100.0;
        }
        if (XiangcaoTierConfig.varietyBonusEnabled() && (effectiveTypes = this.firstSoldThisPeriod.size() + (this.firstSoldThisPeriod.contains(itemId) ? 0 : 1)) >= XiangcaoTierConfig.varietyBonusTypes()) {
            mult *= 1.0 + XiangcaoTierConfig.varietyBonusPercent() / 100.0;
        }
        if (XiangcaoTierConfig.firstSellBonusEnabled() && !this.firstSoldThisPeriod.contains(itemId)) {
            mult *= 1.0 + XiangcaoTierConfig.firstSellBonusPercent() / 100.0;
        }
        if ((capMax = XiangcaoTierConfig.priceCapMax()) > 0.0 && mult > capMax) {
            mult = capMax;
        }
        if ((capMin = XiangcaoTierConfig.priceCapMin()) > 0.0 && mult < capMin) {
            mult = capMin;
        }
        if ((fee = XiangcaoTierConfig.marketFeePercent() / 100.0) > 0.0) {
            mult *= Math.max(0.0, 1.0 - fee);
        }
        return Math.max(0L, Math.round((double)basePrice * mult));
    }

    public static long getEffectivePriceForDisplay(long basePrice, String itemId, Map<String, Double> clientMultipliers) {
        if (!XiangcaoTierConfig.priceVariationEnabled()) {
            return basePrice;
        }
        double mult = clientMultipliers != null ? clientMultipliers.getOrDefault(itemId, 1.0) : 1.0;
        return Math.max(0L, Math.round((double)basePrice * mult));
    }
}

